<?php
if (isset($public) || isset($semRefrescamento)) {
	include_once '../modelo/vagaClassificacao.modelo.php';
}else {
	include_once 'modelo/vagaClassificacao.modelo.php';
} 

 
class ControladorVagaClassificacao
{
  
static public function ctrAddVagaClassificacao($idVaga,$idUsuario,$estrelas)
{
 
	if (!empty($idVaga) && !empty($idUsuario)) 
	{

				$idVaga = addslashes($idVaga);
				$idUsuario = addslashes($idUsuario);
				$estrelas = addslashes($estrelas);
 
				
				$dados = array("idVaga" => filter_var($idVaga,FILTER_SANITIZE_STRIPPED),
				"idUsuario" => filter_var($idUsuario,FILTER_SANITIZE_STRIPPED), 
				"estrelas" => filter_var($estrelas,FILTER_SANITIZE_STRIPPED));
 
				$verifExistencia = ControladorVagaClassificacao::ctrVerificarSeVagaClassificacaoJaExiste($idVaga, $idUsuario);
				if ($verifExistencia == true) 
				{
					$resposta = ModeloVagaClassificacao::mdlAddVagaClassificacao($dados);

					if($resposta == "ok"){ 
						
					}else{
						
					}
				}else
				{
					ControladorVagaClassificacao::ctrAtualizarEstrelasVagaClassificacao($idVaga, $idUsuario, $estrelas);
				}

	}
			else{
				echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Preencha os campos obrigatorios',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
				";	
			}	

}

static public function ctrVerificarSeVagaClassificacaoJaExiste($idVaga, $idUsuario){

	$resposta = ModeloVagaClassificacao::mdlBuscarVagaClassificacao($idVaga, $idUsuario);
	if (empty($resposta)) {
		return true;
	}
	else {
		return false;
	}
}

static public function ctrMostrarMinhaClasseficacao($idVaga, $idUsuario){

	$resposta = ModeloVagaClassificacao::mdlBuscarVagaClassificacao($idVaga, $idUsuario);
	return $resposta;
	
}

static public function ctrBuscarTodasVagaClassificacaoPorIdVaga($idVaga){

	$resposta = ModeloVagaClassificacao::mdlBuscarVagaClassificacaoPorIdVaga($idVaga);
	return $resposta;
	 
}

static public function ctrMediaDeClassificacaoPorIdVaga($idVaga){
	$aval = ControladorVagaClassificacao::ctrBuscarTodasVagaClassificacaoPorIdVaga($idVaga);
	$media = 0; $estrela = 0;

	foreach ($aval as $key => $value) {
		if($value["estrelas"] == "")
		{
			$estrela += 0;
		}else{
			$estrela += $value["estrelas"];
		}
	}
	if(count($aval) == 0)
	{
		return "";
	}else{
		return round($estrela/count($aval));
	}
	
	
}


static public function ctrAtualizarEstrelasVagaClassificacao($idVaga, $idUsuario, $estrelas){
	$resposta = ModeloVagaClassificacao::mdlAtualizarEstrelasVagaClassificacao($idVaga, $idUsuario, $estrelas);
	return $resposta;
}


}

?>